#### Example Bayesian Model Comparison ####
#### Reading in the data ####
## If you get an error when reading in the data, then the following "setwd(..."
## command, change the working directory/file path from path/to/downloaded/file/ 
## to the directory where you saved conflict.csv, and try to read in the data
#setwd("path/to/downloaded/file/")

stress.data <- read.delim("stress_data.csv")
attach(stress.data)

#### Estimating each model ####
# Hypothesis 1: The number of physical health symptoms you report, the more
# psychologically-stressed you feel
model.1 <- glm( psychological.stress ~ symptoms ); summary( model.1 )
## The line above runs your model and stores the model as an object, "model.1," then
## it prints the results of model 1 in a mostly-useful way

# Hypothesis 2: Income will predict less psychological stress
model.2 <- glm( psychological.stress ~ income ); summary( model.2 )
## The above line runs your model and stores the model as an object, "model.2," then
## it prints the results of model 2 in a mostly-useful way
model.3 <- glm( psychological.stress ~ income + symptoms); summary(model.3)

#### Calculating Bayes Factor ####
## summary() does not return BIC by default, but BIC() does!
cat("BIC for Model 1: ", BIC(model.1))
cat("BIC for Model 2: ", BIC(model.2))
cat("Support for model with smaller BIC relative to the other (K) =", abs(BIC(model.2)-BIC(model.1)))